package ru.yandex.antifraud.client;

import java.util.concurrent.Future;

import javax.annotation.Nonnull;

import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;

public class ScoreClient extends AbstractAsyncClient<ScoreClient> {
    @Nonnull
    private final ImmutableHttpHostConfig config;

    public ScoreClient(
            @Nonnull SharedConnectingIOReactor reactor,
            @Nonnull ImmutableHttpHostConfig config) {
        super(reactor, config);
        this.config = config;
    }

    private ScoreClient(
            @Nonnull final CloseableHttpAsyncClient client,
            @Nonnull final ScoreClient sample) {
        super(client, sample);
        this.config = sample.config;
    }

    public Future<JsonObject> execute(@Nonnull JsonMap data) {
        final BasicAsyncRequestProducerGenerator requestProducerGenerator = new BasicAsyncRequestProducerGenerator(
                "/dry_score", JsonType.DOLLAR.toString(data),
                ContentType.APPLICATION_JSON);


        return execute(
                config.host(),
                requestProducerGenerator,
                JsonAsyncTypesafeDomConsumerFactory.OK,
                httpClientContextGenerator(),
                EmptyFutureCallback.instance());
    }

    @Override
    protected ScoreClient adjust(CloseableHttpAsyncClient client) {
        return new ScoreClient(client, this);
    }
}
