package ru.yandex.antifraud.currency;

import java.util.Currency;
import java.util.Objects;

import javax.annotation.Nonnull;

public class Amount {
    private final long amount;
    @Nonnull
    private final Currency currency;

    public Amount(long amount, @Nonnull Currency currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public Amount(long amount, @Nonnull String currencyName) {
        this.amount = amount;
        this.currency = Objects.requireNonNull(CurrencyMap.INSTANCE.getItemByName(currencyName));
    }

    public long amount() {
        return amount;
    }

    @Nonnull
    public Currency currency() {
        return currency;
    }
}
