package ru.yandex.antifraud.currency;

import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum CurrencyMap {
    INSTANCE;
    final Map<Integer, Currency> itemsByNumCode;
    final Map<String, Currency> itemsByStrCode;
    final Map<String, Currency> itemsByName;

    CurrencyMap() {
        final Set<Currency> currencySet = Currency.getAvailableCurrencies();
        itemsByNumCode = new HashMap<>(currencySet.size());
        itemsByStrCode = new HashMap<>(currencySet.size());
        itemsByName = new HashMap<>(currencySet.size());
        for (final Currency currency : currencySet) {
            itemsByNumCode.put(currency.getNumericCode(), currency);
            itemsByStrCode.put(currency.getNumericCodeAsString(), currency);
            itemsByName.put(currency.getCurrencyCode(), currency);
        }
    }

    @Nullable
    public Currency getItemByNumCode(int code) {
        return itemsByNumCode.getOrDefault(code, null);
    }

    @Nullable
    public Currency getItemByStringCode(@Nonnull String code) {
        return itemsByStrCode.getOrDefault(code, null);
    }

    @Nullable
    public Currency getItemByName(@Nonnull String name) {
        return itemsByName.getOrDefault(name, null);
    }
}
