package ru.yandex.antifraud.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class CollapsedAggregatesResponse {
    public final static CollapsedAggregatesResponse EMPTY = new CollapsedAggregatesResponse();
    @Nonnull
    private final List<CollapsedAggregates> aggregatesList;

    private CollapsedAggregatesResponse() {
        aggregatesList = Collections.emptyList();
    }

    public CollapsedAggregatesResponse(@Nonnull JsonMap src) throws JsonException {
        aggregatesList = new ArrayList<>(src.getInt("hitsCount"));

        for (JsonObject el : src.getList("hitsArray")) {
            try {
                aggregatesList.add(new CollapsedAggregates(el.asMap()));
            } catch (JsonException ignored) {
            }
        }
    }

    @Nonnull
    public List<CollapsedAggregates> getAggregatesList() {
        return aggregatesList;
    }
}
