package ru.yandex.antifraud.data;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.lua.util.JsonUtils;

public class Counters {
    public static final String FIRST_ACQUIRE = "first_acquire";
    public static final String LAST_ACQUIRE = "last_acquire";

    public static final String FIRST_ACQUIRE_SRC = "txn_timestamp";
    public static final String LAST_ACQUIRE_SRC = "txn_status_timestamp";

    public final static Counters EMPTY = new Counters();

    @Nonnull
    private final LuaTable counters = new LuaTable();

    private int size = 0;

    @Nonnull
    private final Map<String, LuaTable> countersByIds = new HashMap<>();

    public int update(@Nonnull JsonMap rawObject) throws JsonException {
        final JsonList hits = rawObject.getList("hitsArray");
        size += hits.size();
        for (JsonObject hit : hits) {
            final JsonMap hitMap = hit.asMap();
            final LuaTable counter = new LuaTable();
            countersByIds.put(hit.get("id").asString(), counter);

            counter.set(FIRST_ACQUIRE, hit.get(FIRST_ACQUIRE_SRC).asLong());
            counter.set(LAST_ACQUIRE, hit.get(LAST_ACQUIRE_SRC).asLong());

            final String rawData = hit.get("data").asStringOrNull();
            if (rawData != null) {
                final JsonObject data = TypesafeValueContentHandler.parse(rawData);
                counter.set("data", JsonUtils.jsonToLua(data));
            }

            final String field = hit.get("key").asString();
            final String value = hit.get("value").asString();
            final double count = hitMap.getDouble("count", 0.);

            counter.set("key", field);
            counter.set("value", value);
            counter.set("count", count);

            LuaValue values = counters.get(field);
            if (values == null || values.isnil()) {
                values = new LuaTable();
                counters.set(field, values);
            }

            values.set(value, counter);
        }

        return hits.size();
    }

    @Nonnull
    public LuaTable toLua() {
        return counters;
    }

    public boolean isEmpty() {
        return size > 0;
    }

    @Nonnull
    public Map<String, LuaTable> countersByIds() {
        return countersByIds;
    }
}
