package ru.yandex.antifraud.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class UserContextData {
    public static final UserContextData EMPTY = new UserContextData();

    private final List<JsonMap> userContexts;

    public UserContextData(@Nonnull JsonObject data) throws JsonException {
        final JsonMap asMap = data.asMap();
        final int hits = asMap.getInt("hitsCount");
        userContexts = new ArrayList<>(hits);
        for (final JsonObject rawObject : asMap.getList("hitsArray")) {
            final String rawUserContext = rawObject.asMap().getString("user_context", null);
            if (rawUserContext == null) {
                continue;
            }

            final JsonObject userContext = TypesafeValueContentHandler.parse(rawUserContext);

            if (userContext.type() == JsonObject.Type.MAP && !userContext.asMap().isEmpty()) {
                userContexts.add(userContext.asMap());
            }
        }
    }

    private UserContextData() {
        userContexts = Collections.emptyList();
    }

    public List<JsonMap> userContexts() {
        return userContexts;
    }
}
