package ru.yandex.antifraud.invariants;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.data.Field;
import ru.yandex.json.dom.JsonMap;

public class AfsVerificationLevel {
    @Nullable
    public static String calcAfsVerificationLevel(@Nullable String paymentType,
                                                  @Nullable JsonMap verificationDetails,
                                                  @Nullable Long isAuthed) {
        if (paymentType != null) {
            switch (paymentType) {
                case "standard0":
                case "standard2":
                case "standard2_3ds":
                    return paymentType;
            }
        }

        if (isAuthed != null) {
            if (isAuthed == 0) {
                return "standard2";
            }

            if (isAuthed == 1) {
                return "standard2_3ds";
            }
        }

        if (verificationDetails != null) {
            final String verificationLevel = verificationDetails.getString("verification_level", null);
            if (verificationLevel != null) {
                return Field.BULLSHIT.matcher(verificationLevel).matches() ? null :
                        unifyVerificationLevels(verificationLevel);
            }
        }

        return null;
    }

    @Nullable
    public static String unifyVerificationLevels(@Nonnull String level) {
        switch (level) {
            case "sms":
            case "by_sms":
                return "sms";
            case "flash_call":
            case "by_flash_call":
            case "by_call":
            case "call":
                return "flash_call";
            case "standard2":
            case "std":
                return "standard2";
            case "standard2_3ds":
            case "3ds":
                return "standard2_3ds";
            case "standard0":
            case "zero":
                return "standard0";
            case "email_hint":
            case "phone_confirmation":
            case "phone_hint":
            case "push_2fa":
            case "phone_confirmation_inherited":
            case "question":
            case "captcha":
                return level;
            default:
                return null;
        }
    }
}
