package ru.yandex.antifraud.invariants;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.storage.query.KeyValueQueryNode;
import ru.yandex.antifraud.storage.query.QueryNode;

public enum RequestType {
    MAIN(0),
    AGGRS(0),
    FAST_LIST(1),
    COUNTERS(0),
    COLLAPSED_AGGRS(1),
    VERIFICATION_LEVEL(0),
    SAVE(0);

    public static final String PARAMETER_NAME = "fraud-request-type";

    private final int storagePrefix;

    @Nonnull
    private final QueryNode query;

    RequestType(int storagePrefix) {
        this.storagePrefix = storagePrefix;
        this.query = new KeyValueQueryNode("type", this.name());
    }

    public int storagePrefix() {
        return storagePrefix;
    }

    @Nonnull
    public QueryNode query() {
        return query;
    }
}
