package ru.yandex.antifraud.invariants;

import javax.annotation.Nullable;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.GenericUnaryOperator;

public enum TransactionType {
    BINDING,
    CHECK_CARD,
    COMMON_PAYMENT,
    CVV,
    RECURRING,
    MIT,
    AUTH,
    CASHBACK_PLUS,
    FAMILY_MEMBER_INFO,
    APP,
    PAY,
    PRE_CHECK,
    ;

    public static TransactionType parseFromPaymentType(@Nullable String paymentType,
                                                       @Nullable String paymentMode,
                                                       @Nullable String requestType) {
        if (requestType != null) {
            switch (requestType) {
                case "cvv":
                    return CVV;
                case "confirm":
                case "auth":
                    return AUTH;
                case "cashback-plus":
                    return CASHBACK_PLUS;
                case "family-member-info":
                    return FAMILY_MEMBER_INFO;
                case "app":
                    return APP;
                case "PAY":
                    return PAY;
            }
        }

        if ("recurring".equalsIgnoreCase(paymentMode)) {
            return RECURRING;
        }

        if ("mit".equalsIgnoreCase(requestType)) {
            return MIT;
        }

        if (paymentType == null) {
            return null;
        }

        switch (paymentType) {
            case "check_card":
                return CHECK_CARD;
            case "common_payment":
                return COMMON_PAYMENT;
            case "binding":
            case "standard2":
            case "standard2_3ds":
            case "random_amt":
            case "random_amt_3ds":
            case "standard0":
            case "binding_apple_payment":
            case "binding_google_pay_payment":
            case "binding_xpay_payment":
                return BINDING;
            case "cvv":
                return CVV;
            case "pre_check":
                return PRE_CHECK;
            default:
                return null;
        }
    }

    public enum Parser
            implements GenericFunction<String, TransactionType, Exception> {
        INSTANCE;

        @Override
        public TransactionType apply(final String value) {
            return TransactionType.valueOf(value.trim());
        }
    }

    public enum Validator
            implements GenericUnaryOperator<TransactionType, Exception> {
        INSTANCE;

        @Override
        public TransactionType apply(final TransactionType value) {
            return value;
        }
    }
}
