package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaBoolean;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.ZeroArgFunction;

import ru.yandex.antifraud.aggregates.Aggregates;

public enum AggregatesTuner {
    INSTANCE;

    public void tuneLuaContext(@Nonnull LuaValue context, @Nonnull Aggregates aggregates) {
        final LuaValue luaAggrs = aggregates.asFull();
        context.set("getAggregations", new GetAggregatesFunction(luaAggrs));
        context.set("aggrs", luaAggrs);
        context.set("structured_aggrs", aggregates.structuredFull());
        context.set("aggrs_are_valid", LuaBoolean.valueOf(aggregates.isValid()));
        context.set("counters_are_valid", LuaBoolean.valueOf(aggregates.areCountersValid()));
    }

    static class GetAggregatesFunction extends ZeroArgFunction {
        @Nonnull
        private final LuaValue aggregates;

        GetAggregatesFunction(@Nonnull LuaValue aggregates) {
            this.aggregates = aggregates;
        }

        @Override
        public LuaValue call() {
            return aggregates;
        }
    }
}
