package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaValue;
import jse.org.luaj.vm2.lib.jse.CoerceJavaToLua;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.Field;

public enum ConfigTuner {
    INSTANCE;

    public void tuneLuaContext(@Nonnull LuaValue context, @Nonnull ImmutableChannelConfig config) {
        context.set(Field.CHANNEL_URI.fieldName(), CoerceJavaToLua.coerce(config.channelUri()));
        context.set("storage_service", CoerceJavaToLua.coerce(config.storageService()));
        context.set("storage_login_id_service", CoerceJavaToLua.coerce(config.storageLoginIdService()));
    }
}
