package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.lua.util.JsonUtils;

public class DefaultsTuner extends LuaPackage {
    @Nonnull
    public static final DefaultsTuner EMPTY = new DefaultsTuner(JsonMap.EMPTY);

    @Nonnull
    private final JsonMap luaDefaults;

    public DefaultsTuner(@Nonnull JsonMap luaDefaults) {
        super("lua-defaults");
        this.luaDefaults = luaDefaults;
    }

    @Override
    public void setup(LuaTable pack) {
        for (var entry : luaDefaults.entrySet()) {
            pack.set(entry.getKey(), JsonUtils.jsonToLua(entry.getValue()));
        }
    }
}
