package ru.yandex.antifraud.lua_context_manager;

import java.nio.charset.StandardCharsets;

import com.adobe.internal.xmp.impl.Base64;
import core.org.luaj.vm2.LuaError;
import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.TwoArgFunction;

import ru.yandex.jni.hypocrisy.JniHypocrisy;
import ru.yandex.jni.hypocrisy.JniHypocrisyException;
import ru.yandex.json.parser.JsonException;
import ru.yandex.lua.util.JsonUtils;

public class HypocrisyTuner extends LuaPackage {
    public static final HypocrisyTuner INSTANCE = new HypocrisyTuner();

    public HypocrisyTuner() {
        super("hypocrisy");
    }

    @Override
    public void setup(LuaTable pack) {
        pack.set("decode", new DecodeFunction());
    }

    static class DecodeFunction extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue name, LuaValue encodedFingerPrint) {
            final String secret = System.getenv(name.checkjstring());

            if (secret == null) {
                throw new LuaError("failed to decode: can't find secret: " + name);
            }

            final byte[] decodedSecret = Base64.decode(secret.getBytes(StandardCharsets.UTF_8));

            try {
                return JsonUtils.jsonToLua(JniHypocrisy.decode(decodedSecret, encodedFingerPrint.checkjstring()));
            } catch (JniHypocrisyException | JsonException e) {
                throw new LuaError(e);
            }
        }
    }
}
