package ru.yandex.antifraud.lua_context_manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaError;
import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.OneArgFunction;

import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.lua.util.JsonUtils;

public class JsonTuner extends LuaPackage {
    @Nonnull
    private final Path root;

    public JsonTuner(@Nonnull Path root) {
        super("json");
        this.root = root;
    }

    @Override
    public void setup(LuaTable pack) {
        pack.set("load", new LoadFunction());
        pack.set("loads", new LoadsFunction());
    }

    class LoadFunction extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaPath) {
            if (luaPath == null || !luaPath.isstring()) {
                throw new LuaError(luaPath + " is not string");
            }

            Path path = Path.of(luaPath.checkjstring());

            if (!path.isAbsolute()) {
                path = Path.of(root.toString(), path.toString());
            }

            try (final BufferedReader reader =
                         Files.newBufferedReader(path)) {
                return JsonUtils.jsonToLua(TypesafeValueContentHandler.parse(reader));
            } catch (IOException | JsonException e) {
                throw new LuaError(e);
            }
        }
    }

    static class LoadsFunction extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaStrJson) {
            if (luaStrJson == null || !luaStrJson.isstring()) {
                throw new LuaError(luaStrJson + " is not string");
            }

            try (final Reader reader = new StringReader(luaStrJson.checkjstring())) {
                return JsonUtils.jsonToLua(TypesafeValueContentHandler.parse(reader));
            } catch (IOException | JsonException e) {
                throw new LuaError(e);
            }
        }
    }
}
