package ru.yandex.antifraud.lua_context_manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.ListItem;

public interface ListsProvider {
    @Nonnull
    ListChecker getLists();

    class ListChecker {
        private final Map<String, Map<String, Map<String, Map<String, ListItem>>>> items =
                new HashMap<>();

        public ListChecker(@Nonnull Collection<ListItem> lists) {
            for (ListItem item : lists) {
                items
                        .computeIfAbsent(item.channel(), ignored -> new HashMap<>())
                        .computeIfAbsent(item.subChannel(), ignored -> new HashMap<>())
                        .computeIfAbsent(item.listName(), ignored -> new HashMap<>())
                        .put(item.value(), item);
                if (item.subChannel() != null) {
                    items
                            .computeIfAbsent(item.channel(), ignored -> new HashMap<>())
                            .computeIfAbsent(null, ignored -> new HashMap<>())
                            .computeIfAbsent(item.listName(), ignored -> new HashMap<>())
                            .put(item.value(), item);
                }
            }
        }

        @Nullable
        public TimeRange getRange(
                @Nonnull ImmutableChannelConfig channelConfig,
                @Nonnull String listName,
                @Nonnull String value) {
            final ListItem item = items
                    .getOrDefault(channelConfig.channel(), Collections.emptyMap())
                    .getOrDefault(channelConfig.subChannel(), Collections.emptyMap())
                    .getOrDefault(listName, Collections.emptyMap())
                    .get(value);

            if (item != null) {
                return item.timeRange();
            } else {
                return null;
            }
        }
    }
}
