package ru.yandex.antifraud.lua_context_manager;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.OneArgFunction;
import core.org.luaj.vm2.lib.TwoArgFunction;

public enum LogTuner {
    INSTANCE;

    public void tuneLuaContext(@Nonnull LuaValue context,
                               @Nonnull Logger logger,
                               @Nonnull LuaTable rootLog,
                               @Nonnull LuaTable scriptLog) {
        context.set("logError", new LogFunction(logger, Level.WARNING));
        context.set("logInfo", new LogFunction(logger, Level.FINE));

        context.set("log", new KeyValueLogFunction(scriptLog));
        context.set("root_log", new KeyValueLogFunction(rootLog));
    }

    static class LogFunction extends OneArgFunction {
        final Level logLevel;
        final Logger logger;

        public LogFunction(Logger logger, Level level) {
            this.logLevel = level;
            this.logger = logger;
        }

        @Override
        public LuaValue call(LuaValue arg) {
            logger.log(logLevel, arg.tojstring());
            return LuaValue.NIL;
        }
    }

    public static class KeyValueLogFunction extends TwoArgFunction {
        @Nonnull
        private final LuaTable keyValue;

        public KeyValueLogFunction(@Nonnull LuaTable keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public LuaValue call(LuaValue key, LuaValue value) {
            keyValue.set(key.checkjstring(), value);
            return LuaValue.NIL;
        }
    }
}
