package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.TwoArgFunction;

public abstract class LuaPackage extends TwoArgFunction {
    final String packageName;

    protected LuaPackage(@Nonnull String packageName) {
        this.packageName = packageName;
    }

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        final LuaTable pack = new LuaTable();
        setup(pack);
        env.set(packageName, pack);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set(packageName, pack);
        }
        return pack;
    }

    public abstract void setup(LuaTable pack);
}
