package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import core.org.luaj.vm2.LuaBoolean;
import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.ZeroArgFunction;
import jse.org.luaj.vm2.lib.jse.CoerceJavaToLua;

import ru.yandex.antifraud.rbl.RblData;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.lua.util.JsonUtils;

public enum RblTuner {
    INSTANCE;

    public void tuneLuaContext(@Nonnull LuaValue context, @Nullable RblData rblData) throws JsonBadCastException {
        if (rblData != null) {
            context.set("rbl", JsonUtils.jsonToLua(rblData.toJson()));
        }
        context.set("getIpReputation", new GetIpReputationFunction(rblData));
    }

    static class GetIpReputationFunction extends ZeroArgFunction {
        private final RblData rblData;

        public GetIpReputationFunction(@Nullable RblData rblData) {
            this.rblData = rblData;
        }

        @Override
        public LuaValue call() {
            final LuaTable country = new LuaTable();
            final LuaTable rep = new LuaTable();
            final LuaTable geoip = new LuaTable();

            if (rblData != null) {
                country.set("iso_code", CoerceJavaToLua.coerce(rblData.getIsoCountry()));
                rep.set("is_yandex_net", LuaBoolean.valueOf(rblData.isYandexNet()));
            }
            geoip.set("country", country);
            rep.set("geoip", geoip);

            return rep;
        }
    }
}
