package ru.yandex.antifraud.lua_context_manager;

import java.time.Instant;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.ZeroArgFunction;
import jse.org.luaj.vm2.lib.jse.CoerceJavaToLua;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.lua.util.JsonUtils;


public enum RequestTuner {
    INSTANCE;

    @Nonnull
    static LuaValue requestToLua(@Nonnull ScoringData request, @Nonnull ImmutableChannelConfig config) {
        final LuaValue luaRequest;

        luaRequest = JsonUtils.jsonToLua(request.asJson());

        luaRequest.set(Field.CARD_ID.fieldName(), CoerceJavaToLua.coerce(request.getCardId()));
        luaRequest.set(Field.IP.fieldName(), CoerceJavaToLua.coerce(request.getIp()));
        luaRequest.set(Field.HBF_ID.fieldName(), CoerceJavaToLua.coerce(request.getHbfId()));
        luaRequest.set(Field.AMOUNT.fieldName(), CoerceJavaToLua.coerce(request.getAmount()));
        luaRequest.set(Field.CURRENCY.fieldName(), CoerceJavaToLua.coerce(request.getCurrency()));
        luaRequest.set(Field.PAYED_BY.fieldName(), CoerceJavaToLua.coerce(request.getPayedBy()));
        luaRequest.set(Field.GOOGLE_TOKEN_TYPE.fieldName(), CoerceJavaToLua.coerce(request.getGoogleTokenType()));
        {
            final LuaValue cardBin = CoerceJavaToLua.coerce(request.getCardBin());
            luaRequest.set(Field.CARD_BIN.fieldName(), cardBin);
            luaRequest.set("src_parent", cardBin);
        }
        luaRequest.set(Field.ORDER_TARIF.fieldName(), CoerceJavaToLua.coerce(request.getOrderTarif()));
        luaRequest.set(Field.ORDER_TIPS.fieldName(), CoerceJavaToLua.coerce(request.getOrderTips()));
        luaRequest.set(Field.SUM_TO_PAY.fieldName(), CoerceJavaToLua.coerce(request.getSumToPay()));
        luaRequest.set(Field.TAXI_DRIVER_LICENSE.fieldName(),
                CoerceJavaToLua.coerce(request.getTaxiDriverLicense()));
        luaRequest.set(Field.USER_PHONE.fieldName(), CoerceJavaToLua.coerce(request.getPhone()));
        luaRequest.set(Field.CHANNEL_URI.fieldName(), CoerceJavaToLua.coerce(config.channelUri()));

        return luaRequest;
    }

    public void tuneLuaContext(@Nonnull LuaValue context,
                               @Nonnull ScoringData request,
                               @Nonnull ImmutableChannelConfig config) {
        final LuaValue luaRequest = requestToLua(request, config);

        context.set("getSource", new GetSourceFunctionLegacy(luaRequest));
        context.set("src", luaRequest);
        context.set("nsrc", request.normalized());

        context.set("getEvent", new GetEventFunction(Instant.now().toEpochMilli()));
        context.set("getRequest", new GetSourceFunction(request));
        context.set("getTelemetry", new GetTelemetryFunction());
    }

    static class GetSourceFunctionLegacy extends ZeroArgFunction {
        @Nonnull
        private final LuaValue luaRequest;

        GetSourceFunctionLegacy(@Nonnull LuaValue luaRequest) {
            this.luaRequest = luaRequest;
        }

        @Override
        public LuaValue call() {
            return luaRequest;
        }
    }

    static class GetSourceFunction extends ZeroArgFunction {
        @Nonnull
        private final ScoringData request;

        GetSourceFunction(@Nonnull ScoringData request) {
            this.request = request;
        }

        @Override
        public LuaValue call() {
            return CoerceJavaToLua.coerce(request);
        }
    }

    static class GetEventFunction extends ZeroArgFunction {
        final long value;

        GetEventFunction(long v) {
            value = v;
        }

        @Override
        public LuaValue call() {
            final LuaValue res = new LuaTable();
            res.set("t", value);
            return res;
        }
    }

    static class GetTelemetryFunction extends ZeroArgFunction {
        @Override
        public LuaValue call() {
            return LuaValue.NIL;
        }
    }
}
