package ru.yandex.antifraud.lua_context_manager;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.lua.util.JsonUtils;

public class TemplatesTuner extends LuaPackage {
    @Nonnull
    public static final TemplatesTuner EMPTY = new TemplatesTuner(JsonMap.EMPTY);

    @Nonnull
    private final JsonMap templates;

    public TemplatesTuner(@Nonnull JsonMap templates) {
        super("tanker-templates");
        this.templates = templates;
    }

    @Override
    public void setup(LuaTable pack) {
        for (var entry : templates.entrySet()) {
            pack.set(entry.getKey(), JsonUtils.jsonToLua(entry.getValue()));
        }
    }
}
