package ru.yandex.antifraud.lua_context_manager;

import java.time.Duration;
import java.time.Instant;

import javax.annotation.Nonnull;

public class TimeRange {
    private final Instant start;
    private final Instant end;

    public TimeRange(Instant start, Instant end) throws IllegalTimeRangeException {
        if (start.isAfter(end)) {
            throw new IllegalTimeRangeException(start, end);
        }

        this.start = start;
        this.end = end;
    }

    public boolean contains(Instant t) {
        return t.isAfter(start) && t.isBefore(end);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj
                || (obj instanceof TimeRange
                && start.equals(((TimeRange) obj).start)
                && end.equals(((TimeRange) obj).end));
    }

    @Override
    public int hashCode() {
        return start.hashCode() ^ end.hashCode();
    }

    @Override
    public String toString() {
        return "[" + start + ',' + end + ']';
    }

    @Nonnull
    public Instant getStart() {
        return start;
    }

    @Nonnull
    public Instant getEnd() {
        return end;
    }

    public static class IllegalTimeRangeException extends Exception {
        static final long serialVersionUID = 0L;

        public IllegalTimeRangeException(Duration duration) {
            super(duration + " is negative");
        }

        public IllegalTimeRangeException(Instant start, Instant end) {
            super(start + " is after " + end);
        }
    }
}
