package ru.yandex.antifraud.lua_context_manager;

import java.nio.file.Path;
import java.util.Map;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.OneArgFunction;

import ru.yandex.metrika.uatraits.java.Detector;

public class UaTraitsTuner extends LuaPackage {
    @Nonnull
    private final Detector detector;

    public UaTraitsTuner(@Nonnull Path path) {
        super("uatraits");
        this.detector = new Detector(path.toAbsolutePath().toString());
    }

    @Nonnull
    public Map<String, String> detect(@Nonnull String userAgent) {
        return detector.detect(userAgent);
    }

    @Override
    public void setup(LuaTable pack) {
        pack.set("parse", new ParseFunction());
    }

    class ParseFunction extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue userAgent) {
            final LuaTable result = new LuaTable();

            if (userAgent == null || !userAgent.isstring()) {
                return result;
            }

            for (final Map.Entry<String, String> entry : detect(userAgent.tojstring()).entrySet()) {
                result.set(entry.getKey(), entry.getValue());
            }

            return result;
        }
    }
}
