package ru.yandex.antifraud.lua_context_manager;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import core.org.luaj.vm2.LuaError;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.lib.OneArgFunction;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.antifraud.storage.ServiceVerificationLevelUpdateRequest;
import ru.yandex.antifraud.storage.UpdateRequest;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.lua.util.JsonUtils;

public enum VerificationLevelTuner {
    INSTANCE;

    public static void tuneLuaContext(@Nonnull LuaValue context,
                                      @Nonnull ImmutableChannelConfig channelConfig,
                                      @Nonnull List<UpdateRequest> updateRequests) {

        context.set("update_verification_level",
                new VerificationLevelUpdateFunction(
                        channelConfig.storageLoginIdService(),
                        updateRequests));
    }


    public static class VerificationLevelUpdateFunction extends OneArgFunction {
        @Nonnull
        private final String storageService;
        @Nonnull
        private final List<UpdateRequest> updateRequests;

        public VerificationLevelUpdateFunction(@Nonnull String storageService,
                                               @Nonnull List<UpdateRequest> updateRequests) {
            this.storageService = storageService;
            this.updateRequests = updateRequests;
        }

        @Override
        public LuaValue call(LuaValue arg) {
            try {
                @Nullable final ServiceVerificationLevelUpdateRequest request =
                        ServiceVerificationLevelUpdateRequest.make(
                                new ScoringData(JsonUtils.luaToJson(arg, BasicContainerFactory.INSTANCE).asMap()),
                                storageService
                        );

                if (request == null) {
                    throw new LuaError("cannot create verification level update request from " + JsonUtils.luaAsJson(arg));
                }
                updateRequests.add(request);

                return LuaValue.valueOf(request.id());
            } catch (Exception e) {
                throw new LuaError(e);
            }
        }
    }
}
