package ru.yandex.antifraud.lua_context_manager.config;

import java.io.IOException;
import java.nio.file.Path;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class PrototypesConfigBuilder
        extends AbstractPrototypesConfigBuilder<PrototypesConfigBuilder> {
    public PrototypesConfigBuilder() {
        super(PrototypesConfigDefaults.INSTANCE);
    }

    public PrototypesConfigBuilder(final PrototypesConfig config) {
        super(config);
    }

    public PrototypesConfigBuilder(Path rulesConfigPath, Path rulesRoot)
            throws ConfigException, IOException {
        super(new IniConfig(rulesConfigPath), rulesRoot, PrototypesConfigDefaults.INSTANCE);
    }

    public PrototypesConfigBuilder(
            IniConfig config,
            Path rulesRoot,
            PrototypesConfig defaults)
            throws ConfigException {
        super(config, rulesRoot, defaults);
    }

    public ImmutablePrototypesConfig build() throws ConfigException {
        return new ImmutablePrototypesConfig(this);
    }
}

