package ru.yandex.antifraud.lua_context_manager.config;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.channel.config.ChannelConfigDefaults;
import ru.yandex.json.dom.JsonMap;

public class PrototypesConfigDefaults
        implements PrototypesConfig {

    public static final PrototypesConfigDefaults INSTANCE =
            new PrototypesConfigDefaults();

    protected PrototypesConfigDefaults() {
    }

    @Nullable
    @Override
    public Path additionalScriptsDir() {
        return null;
    }

    @Nullable
    @Override
    public List<String> additionalListsDir() {
        return Collections.emptyList();
    }

    @Nonnull
    @Override
    public Map<String, ChannelConfigDefaults> channels() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public JsonMap luaDefaults() {
        return JsonMap.EMPTY;
    }

    @Override
    @Nonnull
    public Path root() {
        return Path.of(System.getProperty("user.dir"));
    }
}

