package ru.yandex.antifraud.storage;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.channel.ChannelResolver;
import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.lua_context_manager.UnknownChannelException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class GetListNamesRequest {
    @Nonnull
    private final ImmutableChannelConfig channelConfig;

    public GetListNamesRequest(@Nonnull JsonMap rawRequest, @Nonnull ChannelResolver channelResolver) throws JsonException, UnknownChannelException {
        channelConfig = channelResolver.resolve(
                rawRequest.getString("channel"),
                rawRequest.getString("sub_channel", null)
        );
    }

    @Nonnull
    public ImmutableChannelConfig channelConfig() {
        return channelConfig;
    }
}
