package ru.yandex.antifraud.storage;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;

public class ListItemSearchRequest {
    @Nonnull
    private final ImmutableChannelConfig channelConfig;

    @Nonnull
    private final String listName;

    @Nonnull
    private final String value;

    public ListItemSearchRequest(@Nonnull ImmutableChannelConfig channelConfig,
                                 @Nonnull String listName,
                                 @Nonnull String value) {
        this.channelConfig = channelConfig;
        this.listName = listName;
        this.value = value;
    }

    @Nonnull
    public ImmutableChannelConfig channelConfig() {
        return channelConfig;
    }

    @Nonnull
    public String listName() {
        return listName;
    }

    @Nonnull
    public String value() {
        return value;
    }
}
