package ru.yandex.antifraud.storage;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;

import javax.annotation.Nonnull;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.uri.QueryConstructor;

public class MultiRequest implements UpdateRequest {
    @Nonnull
    private final String extid;
    @Nonnull
    private final Key key;
    @Nonnull
    private final Collection<? extends UpdateRequest> requests;
    @Nonnull
    private final String annotation;

    public MultiRequest(@Nonnull String extid, @Nonnull Key key,
                        @Nonnull Collection<? extends UpdateRequest> requests) {
        this.extid = extid;
        this.key = key;
        this.requests = requests;

        final StringJoiner joiner = new StringJoiner(",");
        final Set<String> annotations = new HashSet<>();
        for (UpdateRequest request : requests) {
            if (!annotations.contains(request.annotation())) {
                joiner.add(request.annotation());
                annotations.add(request.annotation());
            }
        }
        annotation = joiner.toString();
    }

    @Override
    public int prefix() {
        return key.getPrefix();
    }

    @Override
    @Nonnull
    public String annotation() {
        return annotation;
    }

    @Override
    @Nonnull
    public String service() {
        return key.getService();
    }

    @Override
    public boolean addIfNotExists() {
        return key.isAddIfNotExists();
    }

    @Override
    public void setupQuery(@Nonnull QueryConstructor queryConstructor) throws BadRequestException {
        queryConstructor.append("extid", extid);
        for (UpdateRequest request : requests) {
            request.setupQuery(queryConstructor);
        }
    }

    @Override
    public void writeDocs(@Nonnull final JsonWriterBase writer)
            throws IOException {
        for (UpdateRequest request : requests) {
            request.writeDocs(writer);
        }
    }
}
