package ru.yandex.antifraud.storage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.invariants.RequestType;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public interface SearchRequest {
    @Nonnull
    String service();

    int prefix();

    @Nullable
    default Integer shard() {
        return null;
    }

    @Nonnull
    default String get() {
        return Field.GET_ALL;
    }

    boolean setupQuery(@Nonnull QueryConstructor queryConstructor) throws BadRequestException;

    @Nonnull
    RequestType requestType();

    @Nullable
    default Integer limit() {
        return null;
    }

    @Nullable
    default QueryConstructor makeDeleteQuery() throws BadRequestException {
        final QueryConstructor queryConstructor = new QueryConstructor("/delete?", false);

        final Integer shard = shard();
        if (shard != null) {
            queryConstructor.append("shard", shard);
        } else {
            queryConstructor.append("prefix", prefix());
        }
        queryConstructor.append("service", service());

        if (!setupQuery(queryConstructor)) {
            return null;
        }

        queryConstructor.append(RequestType.PARAMETER_NAME, requestType().toString());

        return queryConstructor;
    }

    @Nullable
    default QueryConstructor makeSearchQuery() throws BadRequestException {
        final QueryConstructor queryConstructor = new QueryConstructor("/sequential/search?", false);

        final Integer shard = shard();
        if (shard != null) {
            queryConstructor.append("shard", shard);
        } else {
            queryConstructor.append("prefix", prefix());
        }
        queryConstructor.append("service", service());
        queryConstructor.append("json-type", "dollar");
        queryConstructor.append("IO_PRIO", 0);
        queryConstructor.append("early-interrupt", 1);
        queryConstructor.append("get", get());

        if (!setupQuery(queryConstructor)) {
            return null;
        }

        queryConstructor.append(RequestType.PARAMETER_NAME, requestType().toString());

        return queryConstructor;
    }
}
