package ru.yandex.antifraud.storage;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.invariants.RequestType;
import ru.yandex.antifraud.storage.query.BinaryOperation;
import ru.yandex.antifraud.storage.query.BinaryQueryNode;
import ru.yandex.antifraud.storage.query.RawValueQueryNode;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.QueryConstructor;

public class ServiceVerificationLevelSearchUIRequest implements SearchRequest {
    @Nonnull
    private final String query;
    @Nonnull
    private final String storageService;

    public ServiceVerificationLevelSearchUIRequest(@Nonnull JsonMap src, @Nonnull String storageService) throws JsonException, BadRequestException {
        this.query = src.getString("query");
        if (query.isBlank()) {
            throw new BadRequestException("query is empty");
        }
        this.storageService = storageService;
    }

    @Nonnull
    @Override
    public String service() {
        return storageService;
    }

    @Override
    public int prefix() {
        return ServiceVerificationLevelUpdateRequest.REQUEST_TYPE.storagePrefix();
    }

    @Override
    @Nonnull
    public String get() {
        return Field.GET_ALL;
    }

    @Override
    public boolean setupQuery(@Nonnull QueryConstructor queryConstructor) throws BadRequestException {
        final String textQuery = new BinaryQueryNode(
                BinaryOperation.AND,
                new RawValueQueryNode(query),
                ServiceVerificationLevelUpdateRequest.REQUEST_TYPE.query()).encode();

        queryConstructor.append("backend", "ui");
        queryConstructor.append("text", textQuery);

        return true;
    }

    @Override
    @Nonnull
    public RequestType requestType() {
        return ServiceVerificationLevelUpdateRequest.REQUEST_TYPE;
    }
}
