package ru.yandex.antifraud.storage;

import java.io.IOException;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.antifraud.invariants.RequestType;
import ru.yandex.antifraud.util.Shard;
import ru.yandex.json.writer.JsonWriterBase;

public class TransactionUpdateRequest implements UpdateRequest {
    public static final RequestType REQUEST_TYPE = RequestType.MAIN;

    @Nonnull
    private final ScoringData scoringData;

    @Nonnull
    private final ImmutableChannelConfig channelConfig;

    public TransactionUpdateRequest(@Nonnull ScoringData scoringData,
                                    @Nonnull ImmutableChannelConfig channelConfig) {
        this.scoringData = scoringData;
        this.channelConfig = channelConfig;
    }

    @Override
    public int prefix() {
        return (int) Shard.calcByTimestamp(scoringData.getTimestamp());
    }

    @Override
    @Nonnull
    public String annotation() {
        return REQUEST_TYPE.toString();
    }

    @Override
    @Nonnull
    public String service() {
        return channelConfig.storageService();
    }

    @Override
    public boolean addIfNotExists() {
        return false;
    }

    @Override
    public void writeDocs(@Nonnull final JsonWriterBase writer)
        throws IOException
    {
        writer.startObject();
        {
            writer.key("id");
            writer.value("txn_" + scoringData.getExternalId() + '_' + channelConfig.channelUri());

            writer.key("txn_tx_id");
            writer.value(scoringData.getValue(Field.TX_ID).value());

            writer.key("txn_extid");
            writer.value(scoringData.getValue(Field.EXTERNAL_ID).value());

            writer.key("txn_status");
            writer.value(scoringData.getValue(Field.STATUS).value());

            writer.key("txn_is_authed");
            writer.value(scoringData.getValue(Field.AUTHED).longValue(0));

            writer.key("txn_code");
            writer.value(scoringData.getValue(Field.CODE).value("success"));

            writer.key("txn_comment");
            writer.value(scoringData.getValue(Field.COMMENT).value());

            writer.key("txn_status_timestamp");
            writer.value(scoringData.getValue(Field.T).longValue());

            writer.key("channel");
            writer.value(scoringData.getValue(Field.CHANNEL).value());

            writer.key("sub_channel");
            writer.value(scoringData.getValue(Field.SUB_CHANNEL).value());

            writer.key("channel_uri");
            writer.value(channelConfig.channelUri());

            writer.key("type");
            writer.value(REQUEST_TYPE.toString());

            {
                final String afsVerificationLevel = scoringData.getValue(Field.AFS_VERIFICATION_LEVEL).value();
                if (afsVerificationLevel != null) {
                    writer.key(Field.AFS_VERIFICATION_LEVEL.fieldName());
                    writer.value(scoringData.getValue(Field.AFS_VERIFICATION_LEVEL).value());
                }
            }

        }
        writer.endObject();
    }
}
