package ru.yandex.antifraud.storage;

import java.io.IOException;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.invariants.RequestType;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.uri.QueryConstructor;

public interface UpdateRequest extends JsonValue {
    void writeDocs(@Nonnull JsonWriterBase writer) throws IOException;

    int prefix();

    @Nonnull
    String service();

    @Nonnull
    String annotation();

    boolean addIfNotExists();

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        {
            writer.key("AddIfNotExists");
            writer.value(addIfNotExists());

            writer.key("prefix");
            writer.value(prefix());

            writer.key("docs");
            writer.startArray();
            writeDocs(writer);
            writer.endArray();
        }
        writer.endObject();
    }

    @Nonnull
    default Key key() {
        return new Key(prefix(), service(), addIfNotExists());
    }

    default void setupQuery(@Nonnull QueryConstructor queryConstructor) throws BadRequestException {

    }

    @Nonnull
    default QueryConstructor makeQuery() throws BadRequestException {
        final QueryConstructor queryConstructor = new QueryConstructor("/update?", false);
        queryConstructor.append("service", service());
        queryConstructor.append("prefix", prefix());
        queryConstructor.append(RequestType.PARAMETER_NAME, annotation());

        setupQuery(queryConstructor);

        return queryConstructor;
    }

    class Key {
        private final int prefix;
        @Nonnull
        private final String service;
        private final boolean addIfNotExists;

        private final int hashCode;

        public Key(int prefix, @Nonnull String service, boolean addIfNotExists) {
            this.prefix = prefix;
            this.service = service;
            this.addIfNotExists = addIfNotExists;
            hashCode = Integer.hashCode(prefix) ^ service.hashCode() ^ Boolean.hashCode(addIfNotExists);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key rhs = (Key) o;
            return prefix == rhs.prefix && service.equals(rhs.service) && addIfNotExists == rhs.addIfNotExists;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        public int getPrefix() {
            return prefix;
        }

        @Nonnull
        public String getService() {
            return service;
        }

        public boolean isAddIfNotExists() {
            return addIfNotExists;
        }
    }
}
