package ru.yandex.antifraud.storage.config;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.invariants.TransactionType;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableStorageConfig
        implements StorageConfig {
    private final int responseLimit;

    @Nonnull
    private final ImmutableHttpHostConfig searchConfig;

    @Nullable
    private final ImmutableHttpHostConfig saveConfig;

    @Nonnull
    private final List<Field> fieldsToFetch;

    @Nonnull
    private final List<TransactionType> transactionTypesToFetch;

    public ImmutableStorageConfig(final StorageConfig config)
            throws ConfigException {
        responseLimit = config.responseLimit();
        searchConfig = new ImmutableHttpHostConfig(config.searchConfig());

        if (config.saveConfig() != null) {
            saveConfig = new ImmutableHttpHostConfig(config.saveConfig());
        } else {
            saveConfig = null;
        }

        fieldsToFetch = config.fieldsToFetch();
        transactionTypesToFetch = config.transactionTypesToFetch();
    }

    @Override
    public int responseLimit() {
        return responseLimit;
    }

    @Nonnull
    @Override
    public ImmutableHttpHostConfig searchConfig() {
        return searchConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig saveConfig() {
        return saveConfig;
    }

    @Nonnull
    @Override
    public List<Field> fieldsToFetch() {
        return fieldsToFetch;
    }

    @Override
    @Nonnull
    public List<TransactionType> transactionTypesToFetch() {
        return transactionTypesToFetch;
    }
}

