package ru.yandex.antifraud.storage.config;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.invariants.TransactionType;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;

public interface StorageConfig {
    ParameterConfig<List<Field>> FIELDS_TO_FETCH = new ParameterConfig<>(
            "fields-to-fetch",
            new CollectionParser<>(
                    Field.Parser.INSTANCE,
                    ArrayList::new),
            new CollectionValidator<Field, List<Field>>(Field.Validator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(ArrayList::new));

    ParameterConfig<List<TransactionType>> TRANSACTION_TYPES_TO_FETCH = new ParameterConfig<>(
            "transaction-types-to-fetch",
            new CollectionParser<>(
                    TransactionType.Parser.INSTANCE,
                    ArrayList::new),
            new CollectionValidator<TransactionType, List<TransactionType>>(TransactionType.Validator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(ArrayList::new));

    int responseLimit();

    @Nonnull
    HttpHostConfig searchConfig();

    @Nullable
    HttpHostConfig saveConfig();

    @Nonnull
    List<Field> fieldsToFetch();

    @Nonnull
    List<TransactionType> transactionTypesToFetch();
}

