package ru.yandex.antifraud.storage.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class StorageConfigBuilder
        extends AbstractStorageConfigBuilder<StorageConfigBuilder> {
    public StorageConfigBuilder() {
        super(StorageConfigDefaults.INSTANCE);
    }

    public StorageConfigBuilder(final StorageConfig config) {
        super(config);
    }

    public StorageConfigBuilder(final IniConfig config)
            throws ConfigException {
        super(config, StorageConfigDefaults.INSTANCE);
    }

    public StorageConfigBuilder(
            final IniConfig config,
            final StorageConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    public ImmutableStorageConfig build() throws ConfigException {
        return new ImmutableStorageConfig(this);
    }
}

