package ru.yandex.antifraud.storage.config;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.data.Field;
import ru.yandex.antifraud.invariants.TransactionType;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;

public class StorageConfigDefaults
        implements StorageConfig {

    public static final StorageConfigDefaults INSTANCE =
            new StorageConfigDefaults();

    protected StorageConfigDefaults() {
    }

    @Override
    public int responseLimit() {
        return 0;
    }

    @Nonnull
    @Override
    public HttpHostConfig searchConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig saveConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public List<Field> fieldsToFetch() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<TransactionType> transactionTypesToFetch() {
        return Collections.emptyList();
    }
}

