package ru.yandex.antifraud.storage.query;

import javax.annotation.Nonnull;

import ru.yandex.search.request.util.SearchRequestText;

public class KeyValueQueryNode implements QueryNode {
    @Nonnull
    private final String key;
    @Nonnull
    private final QueryNode value;

    public KeyValueQueryNode(@Nonnull String key, @Nonnull QueryNode value) {
        this.key = key;
        this.value = value;
    }

    public KeyValueQueryNode(@Nonnull String key, @Nonnull String value) {
        this.key = key;
        this.value = new StringValueQueryNode(value);
    }

    public KeyValueQueryNode(@Nonnull String key, @Nonnull Long value) {
        this.key = key;
        this.value = new LongValueQueryNode(value);
    }

    @Override
    public void encode(StringBuilder textQuery,
                       boolean isRoot) {
        textQuery.append(SearchRequestText.fullEscape(key, false));
        textQuery.append(':');
        value.encode(textQuery, false);
    }
}
