package ru.yandex.antifraud.storage.query;

import java.time.Instant;

import javax.annotation.Nonnull;

public class RangeQueryNode implements QueryNode {
    @Nonnull
    private final Instant since;
    @Nonnull
    private final Instant until;

    public RangeQueryNode(@Nonnull Instant since, @Nonnull Instant until) {
        this.since = since;
        this.until = until;
    }

    @Override
    public void encode(StringBuilder textQuery,
                       boolean isRoot) {
        textQuery.append('[');
        textQuery.append(since.toEpochMilli());
        textQuery.append(" TO ");
        textQuery.append(until.toEpochMilli());
        textQuery.append(']');
    }
}
