package ru.yandex.antifraud.storage.query;

import javax.annotation.Nonnull;

import ru.yandex.search.request.util.SearchRequestText;

public class StringValueQueryNode implements QueryNode {
    @Nonnull
    private final String value;

    public StringValueQueryNode(@Nonnull String value) {
        this.value = value;
    }

    @Override
    public void encode(StringBuilder textQuery,
                       boolean isRoot) {
        textQuery.append('"');
        textQuery.append(SearchRequestText.fullEscape(value, false));
        textQuery.append('"');
    }
}
