package ru.yandex.antifraud.util;

import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaString;

import ru.yandex.antifraud.aggregates.Aggregator;
import ru.yandex.antifraud.aggregates.FieldAcceptor;
import ru.yandex.antifraud.aggregates_v2.AggregatedTimeRange;

public enum AggregatesNamesCache {
    INSTANCE;
    private static final Map<FieldAcceptor, Map<Aggregator, Map<AggregatedTimeRange, Names>>> NAMES_CACHE;

    @Nonnull
    public Names names(@Nonnull FieldAcceptor field,
                       @Nonnull Aggregator aggregator,
                       @Nonnull AggregatedTimeRange timeRange) {
        return NAMES_CACHE.get(field).get(aggregator).get(timeRange);
    }

    static {
        NAMES_CACHE = new EnumMap<>(FieldAcceptor.class);
        for (FieldAcceptor fieldAcceptor : FieldAcceptor.values()) {
            for (Aggregator aggregator : Aggregator.values()) {
                for (AggregatedTimeRange timeRange : AggregatedTimeRange.values()) {
                    NAMES_CACHE
                            .computeIfAbsent(fieldAcceptor, unused -> new EnumMap<>(Aggregator.class))
                            .computeIfAbsent(aggregator, unused -> new EnumMap<>(AggregatedTimeRange.class))
                            .put(timeRange,
                                    new Names(fieldAcceptor,
                                            aggregator,
                                            timeRange));
                }
            }
        }
    }

    public static class Names {
        @Nonnull
        private final String javaSetName;
        @Nonnull
        private final String javaCntName;
        @Nonnull
        private final String javaLongName;
        @Nonnull
        private final LuaString luaSetName;
        @Nonnull
        private final LuaString luaCntName;
        @Nonnull
        private final LuaString luaLongName;

        public Names(@Nonnull FieldAcceptor field,
                     @Nonnull Aggregator aggregator,
                     @Nonnull AggregatedTimeRange timeRange) {
            javaLongName = field.getName() + '_' + aggregator.getName() + '_' + timeRange.getName();
            javaSetName = javaLongName + "_set";
            javaCntName = field.getName() + '_' + aggregator.getName() + "_cnt_" + timeRange.getName();

            luaSetName = LuaString.valueOf(javaSetName);
            luaCntName = LuaString.valueOf(javaCntName);
            luaLongName = LuaString.valueOf(javaLongName);
        }

        @Nonnull
        public String javaSetName() {
            return javaSetName;
        }

        @Nonnull
        public String javaCntName() {
            return javaCntName;
        }

        @Nonnull
        public String javaLongName() {
            return javaLongName;
        }

        @Nonnull
        public LuaString luaSetName() {
            return luaSetName;
        }

        @Nonnull
        public LuaString luaCntName() {
            return luaCntName;
        }

        @Nonnull
        public LuaString luaLongName() {
            return luaLongName;
        }
    }
}
