package ru.yandex.antifraud.util;

import java.util.function.Function;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;

public interface AsyncClientHostRegistrar {
    AsyncClient clientHost(
            String name,
            ImmutableHttpHostConfig config,
            Function<? super Exception, RequestErrorType> errorClassifier);

    // Adds client to close chain and returns client with automatic tvm headers
    <T extends AbstractAsyncClient<T>> T registerClientHost(
            String name,
            T client,
            ImmutableHttpHostConfig config);
}
