package ru.yandex.antifraud.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.CallbackFutureBase;

public class CollapseListsCallback<T> extends CallbackFutureBase<List<T>, List<List<T>>> {
    protected CollapseListsCallback(FutureCallback<? super List<T>> callback) {
        super(callback);
    }

    @Override
    protected List<T> convertResult(List<List<T>> lists) {
        List<T> collapsedList = new ArrayList<>();
        for (List<T> list : lists) {
            collapsedList.addAll(list);
        }
        return collapsedList;
    }
}
