package ru.yandex.antifraud.util;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;


public class ErrorLoggingFutureCallback<T> implements FutureCallback<T> {
    @Nonnull
    protected final FutureCallback<? super T> callback;
    @Nonnull
    protected final Supplier<? extends T> defaultValue;
    @Nonnull
    protected final Logger logger;

    public ErrorLoggingFutureCallback(
            @Nonnull FutureCallback<? super T> callback,
            @Nonnull Supplier<? extends T> defaultValue,
            @Nonnull Logger logger) {
        this.callback = callback;
        this.defaultValue = defaultValue;
        this.logger = logger;
    }

    public ErrorLoggingFutureCallback(
            @Nonnull FutureCallback<? super T> callback,
            @Nonnull Logger logger) {
        this(callback, () -> null, logger);
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        logger.log(Level.WARNING, "suppressed error", e);
        completed(defaultValue.get());
    }

    @Override
    public void completed(final T result) {
        callback.completed(result);
    }
}
