package ru.yandex.antifraud.util;

import java.util.concurrent.Executor;

import org.apache.http.concurrent.FutureCallback;

public class ExecutedCallbackFutureBase<T> implements FutureCallback<T> {
    protected final Executor executor;
    private final FutureCallback<? super T> callback;

    public ExecutedCallbackFutureBase(Executor executor,
                                      FutureCallback<? super T> callback) {
        this.executor = executor;
        this.callback = callback;
    }

    @Override
    public void completed(final T result) {
        executor.execute(() -> {
            callback.completed(result);
        });
    }

    @Override
    public void failed(Exception e) {
        executor.execute(() -> {
            callback.failed(e);
        });
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }
}
