package ru.yandex.antifraud.util;

import java.util.function.Function;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.CallbackFutureBase;


public class GenericFutureCallback<T, R> extends CallbackFutureBase<R, T> {
    @Nonnull
    private final Function<T, R> converter;

    public GenericFutureCallback(@Nonnull Function<T, R> converter, FutureCallback<? super R> callback) {
        super(callback);
        this.converter = converter;
    }

    @Override
    protected R convertResult(T result) {
        return converter.apply(result);
    }
}
