package ru.yandex.antifraud.util;


import java.util.List;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.CallbackFutureBase;

public class JoinStringsCallback extends CallbackFutureBase<String, List<String>> {
    @Nonnull
    private final CharSequence delimiter;

    public JoinStringsCallback(@Nonnull FutureCallback<String> callback) {
        this(",", callback);
    }

    public JoinStringsCallback(@Nonnull CharSequence delimiter, @Nonnull FutureCallback<String> callback) {
        super(callback);
        this.delimiter = delimiter;
    }

    @Override
    protected String convertResult(List<String> results) {
        return String.join(delimiter, results);
    }
}
