package ru.yandex.antifraud.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import javax.annotation.Nullable;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.Processable;
import ru.yandex.http.util.CallbackFutureBase;
import ru.yandex.io.ByteArrayInputStreamFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class JsonParsingCallback
        extends CallbackFutureBase<JsonObject, Processable<byte[]>> {

    public JsonParsingCallback(FutureCallback<JsonObject> callback) {
        super(callback);
    }

    @Override
    @Nullable
    protected JsonObject convertResult(Processable<byte[]> response) {
        try (final BufferedReader reader =
                     new BufferedReader(
                             new InputStreamReader(
                                     response.processWith(ByteArrayInputStreamFactory.INSTANCE),
                                     Charset.defaultCharset()))) {
            return TypesafeValueContentHandler.parse(reader);
        } catch (IOException | JsonException e) {
            onFailure(e);
            return null;
        }
    }
}
