package ru.yandex.antifraud.util;

import java.io.IOException;

import javax.annotation.Nonnull;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;

public class JsonWriterSb extends JsonWriter {
    final StringBuilderWriter sbw;

    private JsonWriterSb(StringBuilderWriter sbw) {
        super(sbw);
        this.sbw = sbw;
    }

    @Nonnull
    public static JsonWriterSb create() throws IOException {
        final JsonWriterSb writer = new JsonWriterSb(new StringBuilderWriter());
        writer.startObject();
        return writer;
    }

    @Nonnull
    @Override
    public String toString() {
        return sbw.toString();
    }

    public <T> void kv(String k, T v) throws IOException {
        key(k);
        value(v);
    }

    @Override
    public void close() throws IOException {
        endObject();
        super.close();
    }
}
