package ru.yandex.antifraud.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import javax.annotation.Nullable;

import core.org.luaj.vm2.LuaValue;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.Processable;
import ru.yandex.http.util.CallbackFutureBase;
import ru.yandex.io.ByteArrayInputStreamFactory;
import ru.yandex.json.parser.JsonException;
import ru.yandex.lua.util.TypesafeLuaValueContentHandler;

public class LuaParsingCallback
        extends CallbackFutureBase<LuaValue, Processable<byte[]>> {

    public LuaParsingCallback(FutureCallback<LuaValue> callback) {
        super(callback);
    }

    @Override
    @Nullable
    protected LuaValue convertResult(Processable<byte[]> response) {
        try (final BufferedReader reader =
                     new BufferedReader(
                             new InputStreamReader(
                                     response.processWith(ByteArrayInputStreamFactory.INSTANCE),
                                     Charset.defaultCharset()))) {
            return TypesafeLuaValueContentHandler.parse(reader);
        } catch (IOException | JsonException e) {
            onFailure(e);
            return null;
        }
    }
}
