package ru.yandex.antifraud.util;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

public class MultiCounter {
    private final Integer countersSize;
    private final List<Integer> counters;
    private final List<Integer> limits;
    private final int totalSize;

    public MultiCounter(List<Integer> limits) {
        countersSize = limits.size();
        counters = new ArrayList<>(countersSize);

        {
            int totalSize = 1;
            for (int limit : limits) {
                counters.add(0);
                if (limit > 0) {
                    totalSize *= limit;
                }
            }
            this.totalSize = totalSize;
        }
        this.limits = limits;
    }

    public boolean next() {
        int previousCounter = -1;
        for (int i = 0; i < countersSize; i++) {
            final int limit = limits.get(i);
            if (limit > 0) {
                final int counter = counters.get(i);
                if (counter < limit - 1) {
                    counters.set(i, counter + 1);
                    if (previousCounter != -1) {
                        counters.set(previousCounter, 0);
                    }
                    return true;
                } else {
                    previousCounter = i;
                }
            }
        }
        return false;
    }

    @Nonnull
    public List<Integer> indexes() {
        return counters;
    }

    public int size() {
        return totalSize;
    }
}
